<?php
defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_THEME', __('Themes', 'theme'));

class Theme_Plugin extends Pf_Plugin{
    public $name = PLUGIN_THEME;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'Theme Management';

    public function admin_init(){
        if(is_admin()){
            $this->admin_menu ( 'fa fa-eye', __('Themes', 'theme'), 'themes', 'theme_manager_main' );
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Themes', 'theme'), 'themes', 'theme_manager_main', 'Themes' );
            if(file_exists(ABSPATH . '/themes/'.get_option('active_theme').'/options.php')){
                if(is_ajax() && file_exists(ABSPATH . '/themes/'.get_option('active_theme').'/options-ajax.php')){
                    require ABSPATH . '/themes/'.get_option('active_theme').'/options-ajax.php';
                }
                $this->admin_children_menu ( 'fa fa-angle-double-right', __('Theme Options', 'theme'), 'options', 'options_manager_main', 'Themes' );
            }
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Layouts', 'theme'), 'layouts', 'layout_manager_main', 'Themes' );
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Widgets', 'theme'), 'widgets', 'widget_manager_main', 'Themes' );
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Footer', 'theme'), 'footer', 'footer_manager_main', 'Themes' );
        }
    }
    function theme_manager_main() {
        $this->css( 'admin/themes/default/assets/bootstrap-modal/css/animate.min.css' );
        $this->css( 'theme/layouts/css/theme-layouts.css',__FILE__ );
        
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js' );
        $this->js ( 'admin/themes/default/assets/js/json2.js' );
        $this->js( 'theme/layouts/js/theme-layouts.js',__FILE__ );
    
        require abs_plugin_path(__FILE__) . '/theme/themes/includes/functions.php';
        require abs_plugin_path(__FILE__) . '/theme/themes/themes.php';
    }
    function options_manager_main(){
        require abs_plugin_path(__FILE__) . '/theme/options/options.php';
    }
    
    function layout_manager_main() {
        $this->css ( 'admin/themes/default/assets/bootstrap-modal/css/animate.min.css' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js' );
        $this->js ( 'admin/themes/default/assets/js/json2.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        $this->js ( 'admin/themes/default/assets/js/notification.js' );
        
        $this->css ( 'theme/layouts/css/theme-layouts.css',__FILE__ );
        $this->js ( 'theme/layouts/js/theme-layouts.js',__FILE__ );
    
        require abs_plugin_path(__FILE__) . '/theme/widgets/includes/functions.php';
        require abs_plugin_path(__FILE__) . '/theme/layouts/layouts.php';
    }
    
    public function footer_manager_main(){
        $this->css ( 'admin/themes/default/assets/bootstrap-modal/css/animate.min.css' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js' );
        $this->js ( 'admin/themes/default/assets/js/json2.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        $this->js ( 'admin/themes/default/assets/js/notification.js' );
        $this->css ( 'theme/layouts/css/theme-layouts.css',__FILE__ );
        $this->js ( 'theme/layouts/js/theme-layouts.js',__FILE__ );
        
        require abs_plugin_path(__FILE__) . '/theme/widgets/includes/functions.php';
        require abs_plugin_path(__FILE__) . '/theme/footer/footer.php';
    }
    
    function widget_manager_main() {
        require abs_plugin_path(__FILE__) . '/theme/widgets/includes/functions.php';
        require abs_plugin_path(__FILE__) . '/theme/widgets/widgets.php';
    }
    
}